#include <bits/stdc++.h>

#define N 200'000

auto str_to_vec(const char* str, const size_t n) -> std::vector<bool> {
	std::vector<bool> rez(n, 0);
	for (size_t i = 0; i < n; ++i) {
		if (str[i] == '1')
			rez[i] = true;
	}
	return rez;
}

void apply_changes(std::vector<bool>& s, const size_t l, const size_t r) {
	for (size_t i = l - 1; i < r; ++i) {
		s[i] = !s[i];
	}
}

auto min_cost(const std::vector<bool>& s, const size_t c) -> size_t {
	const size_t ones = std::count(cbegin(s), cend(s), true);
	const size_t zeroes = s.size() - ones;
	return std::min(ones, zeroes + c);
}

auto main() -> int {
	std::ios_base::sync_with_stdio(false);

	size_t n, c, q;
	std::cin >> n >> c >> q;
	
	char s_[N];
	std::cin >> s_;

	std::vector<bool> s = str_to_vec(s_, n);

	for (size_t i = 0; i < q; ++i) {
		size_t l, r;
		std::cin >> l >> r;
		apply_changes(s, l, r);
		std::cout << min_cost(s, c) << '\n';
	}
}